#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR Low Pass *******

Function MPRLowPassReset()
	MPRLowPassSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "mlp_compute(\"\")"
End

Function ButtonMPRLowPass(ctrlName) : ButtonControl
	String ctrlName
	
	DoWindow/F WMMPRLowPassDesign
	if( V_Flag==0 )
		MPRLowPassSetupDesign()
	endif
End

Function MPRLowPassSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs
	String dfSav= Set_IFDL_DataFolder()

	Variable pEnd=NumVarOrDefault("mlp_pe",0.2)
	Variable pErr=NumVarOrDefault("mlp_perr",0.5)
	Variable sStrt=NumVarOrDefault("mlp_ss",0.25)
	Variable sAttn=NumVarOrDefault("mlp_satt",40)
	Variable eo=NumVarOrDefault("mlp_eo",2)

	pErr=abs(pErr)
	sAttn=abs(sAttn)

	// Create the globals
	Variable/G mlp_pe=pEnd
	Variable/G mlp_perr=pErr
	Variable/G mlp_ss=sStrt
	Variable/G mlp_satt=sAttn
	Variable/G mlp_eo=eo
	Variable/G mlp_n=NumVarOrDefault("mlp_n",NaN)

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G mlp_pe_fs= pEnd * fs
	Variable/G mlp_ss_fs= sStrt * fs
	
	SetDataFolder dfSav

	MPRLowPassUpdate()
	
	CreateMPRLowPassDesign()
	MPRLowPassUpdate()			// set the control limits, too.
End

// update waves that show the MPR Lowpass design parameters
// This is called whenever any parameters change.
Function MPRLowPassUpdate()

	String dfSav= Set_IFDL_DataFolder()
	NVAR fs= fs
	Variable pEndFs=NumVarOrDefault("mlp_pe_fs",0.2*fs)
	Variable pErr=NumVarOrDefault("mlp_perr",0.22)
	Variable sStrtFs=NumVarOrDefault("mlp_ss_fs",0.25*fs)
	Variable sAttn=NumVarOrDefault("mlp_satt",40)

	pErr= abs(pErr)
	sAttn= abs(sAttn)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G mlp_pe=pEndFs/fs
	Variable/G mlp_ss=sStrtFs/fs

	// Passband and stop band response pair, in dB
	Make/O mprlp_responseX = {0,pEndFs,NaN,sStrtFs,fs*0.5}
	Make/O mprlp_response  = {0,0,NaN,-sAttn,-sAttn}
	// passband error waves
	Make/O     mprlp_passErrorX = {0,mprlp_responseX[1]}
	Make/O/N=2 mprlp_passErrorPlus= pErr
	Make/O/N=2 mprlp_passErrorMinus= -pErr
	// transition region waves
	Make/O     mprlp_transitionX = {mprlp_responseX[1],mprlp_responseX[3]}
	Make/O/N=2 mprlp_transitionPlus = pErr
	Make/O/N=2 mprlp_transitionMinus = -sAttn

	DoWindow WMMPRLowPassDesign
	if( V_Flag == 1 ) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMMPRLowPassDesign mlp_PE
		Variable passBandEnd= V_Value
		ControlInfo/W=WMMPRLowPassDesign mlp_sStrt
		Variable stopBandStart= V_Value
		// back-compute from max n the minimum separation of stopBandStart and passBandEnd
		pErr=1-alog(-pErr/20)
		sAttn=alog(-sAttn/20)
		// n= ceil(1+(-20*log(sqrt(pErr*sAttn))-13)/(14.6*(transitionWidth)/fs))
		Variable maxN= 998 // one less than the max to account for ceil
		// solve for transitionWidth, with fixed maximal N
		Variable minTransitionWidth = fs * (-20*log(sqrt(pErr*sAttn))-13) / (14.6*(maxN-1))
		Variable df=  NiceNumber(fs/200)
		// don't make max smaller than current value
		Variable endMax= max(passBandEnd,stopBandStart-minTransitionWidth)
		endMax= limit(endMax,0,fs/2)
		SetVariable mlp_PE,limits={0,endMax,df},win=WMMPRLowPassDesign
		// don't make min bigger than current value
		Variable startMin= min(stopBandStart,passBandEnd+minTransitionWidth)
		startMin= limit(startMin,0, fs/2)
		SetVariable mlp_sStrt,limits={startMin,fs/2,df},win=WMMPRLowPassDesign

		// show the computed number of terms before computing the filter.
		ControlInfo/W=WMMPRLowPassDesign mlp_evenOdd	// "even;odd"
		Variable eo= V_Value
	
		Variable/G mlp_n=ceil(1+(-20*log(sqrt(pErr*sAttn))-13)/(14.6*(sStrtFs-pEndFs)/fs))
		if ((mlp_n-2*trunc(mlp_n/2)) != (eo-1))
			mlp_n += 1
		endif
		ControlUpdate/A/W=WMMPRLowPassDesign
	endif
	SetDataFolder dfSav
End

Function CreateMPRLowPassDesign()

	if( DesignGraph("WMMPRLowPassDesign","MPR Low Pass Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft  mprlp_transitionPlus,mprlp_transitionMinus vs mprlp_transitionX
	AppendToGraph/L=responseLeft mprlp_passErrorPlus,mprlp_passErrorMinus vs mprlp_passErrorX
	AppendToGraph/L=responseLeft mprlp_response vs mprlp_responseX
	SetDataFolder dfSav
	
	ModifyGraph mode(mprlp_transitionPlus)=7,mode(mprlp_passErrorPlus)=7
	ModifyGraph lSize(mprlp_transitionPlus)=0,lSize(mprlp_transitionMinus)=0,lSize(mprlp_passErrorPlus)=0
	ModifyGraph lSize(mprlp_passErrorMinus)=0
	ModifyGraph rgb(mprlp_transitionPlus)=(56797,56797,56797),rgb(mprlp_passErrorPlus)=(65535,49151,49151)
	ModifyGraph hbFill(mprlp_transitionPlus)=2,hbFill(mprlp_passErrorPlus)=2
	ModifyGraph toMode(mprlp_transitionPlus)=1,toMode(mprlp_passErrorPlus)=1
	ModifyGraph lblPos(responseLeft)=56
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft "response (dB)"
	ControlBar 64
	SetVariable mlp_PE,pos={14,3},size={211,17},proc=MPR_mlp,title="End of Pass Band"
	SetVariable mlp_PE,limits={0,fs/2,df},value= root:Packages:WM_IFDL:mlp_pe_fs
	SetVariable mlp_sStrt,pos={237,3},size={245,17},proc=MPR_mlp,title="Start of Stop Band"
	SetVariable mlp_sStrt,limits={0,fs/2,df},value= root:Packages:WM_IFDL:mlp_ss_fs
	SetVariable mlp_PErr,pos={13,22},size={212,17},proc=MPR_mlp,title="Max Pass Band Error (dB)"
	SetVariable mlp_PErr,limits={0.001,Inf,0.5},value= root:Packages:WM_IFDL:mlp_perr
	SetVariable mlp_sAttn,pos={237,22},size={245,17},proc=MPR_mlp,title="Min Stop Band Attenuation (dB)"
	SetVariable mlp_sAttn,limits={0,Inf,5},value= root:Packages:WM_IFDL:mlp_satt
	PopupMenu mlp_evenOdd,pos={12,42},size={167,19},proc=mlpEvenOddPopup,title="Number of Terms"
	PopupMenu mlp_evenOdd,mode=2,popvalue="odd",value= #"\"even;odd\""
	ValDisplay mlpTerms,pos={195,43},size={161,17},title="Computed Terms:",frame=0
	ValDisplay mlpTerms,limits={0,0,0},barmisc={0,1000}, frame=(IsWindowsPlatform())
	ValDisplay mlpTerms,value= #"root:Packages:WM_IFDL:mlp_n"
	Button mlpCompute,pos={361,42},size={109,19},proc=mlp_compute,title="Compute Filter"
	Textbox/N=mlpLegend/X=-0.73/Y=18.02 ""
	mlpLegend()
	SetWindow WMMPRLowPassDesign, hook=designHook
	return 0
End

Function MPR_mlp(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	
	MPRLowPassUpdate()
End

Function mlpEvenOddPopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR eo= root:Packages:WM_IFDL:mlp_eo
	eo= popNum
	MPRLowPassUpdate()
End

Function mlpLegend()
	DesignLegend("WMMPRLowPassDesign","mprlp","mlpLegend")
End


Proc mlp_compute(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate	// MPR Low Pass...
	String dfSav= Set_IFDL_DataFolder()

	Variable pEnd= mlp_pe_fs
	Variable pErr= abs(mlp_perr)
	Variable sStrt=mlp_ss_fs
	Variable sAttn=abs(mlp_satt)
	ControlInfo/W=WMMPRLowPassDesign mlp_evenOdd	// "even;odd"
	Variable eo= V_Value

	pErr=1-alog(-pErr/20)
	sAttn=alog(-sAttn/20)
	Variable/G mlp_n=ceil(1+(-20*log(sqrt(pErr*sAttn))-13)/(14.6*(sStrt-pEnd)/fs))
	if ((mlp_n-2*trunc(mlp_n/2)) != (eo-1))
		mlp_n += 1
	endif
	Variable n=mlp_n
	SetDataFolder dfSav
	if( n > 9999 )
		Abort "Too many filter terms. Widen the transition band or allow more passband error."
	endif 
	String/G root:Packages:WM_IFDL:proposedFilterName="mprLowPass"
	PMPR2BandNoShow(1,n,pEnd,sStrt,sAttn/pErr)
	DoWindow/F WMMPRLowPassDesign
	CheckDisplayed/W=WMMPRLowPassDesign root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		Append/L=responseLeft root:Packages:WM_IFDL:coefsDbMag
		ModifyGraph rgb(coefsDbMag)=(0,0,65535)
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:dbmagPassDetails)	// appends /L=detailsLeft
	String axisName= TraceAxis("WMMPRLowPassDesign","mprlp_passErrorPlus",1,1)	// mprlp_passErrorPlus#1
	if( CmpStr(axisName,"detailsLeft") != 0 )
		AppendToGraph/L=detailsLeft root:Packages:WM_IFDL:mprlp_passErrorPlus vs root:Packages:WM_IFDL:mprlp_passErrorX
		AppendToGraph/L=detailsLeft root:Packages:WM_IFDL:mprlp_passErrorMinus vs root:Packages:WM_IFDL:mprlp_passErrorX
		Label detailsLeft "details (dB)"
		ModifyGraph mode(mprlp_passErrorPlus#1)=7
		ModifyGraph lSize(mprlp_passErrorPlus#1)=0,lSize(mprlp_passErrorMinus#1)=0
		ModifyGraph rgb(mprlp_passErrorPlus#1)=(65535,49151,49151)
		ModifyGraph hbFill(mprlp_passErrorPlus#1)=2
		ModifyGraph toMode(mprlp_passErrorPlus#1)=1
		ReorderTraces dbmagPassDetails, {mprlp_passErrorPlus#1,mprlp_passErrorMinus#1}
	endif
	AutoApplyFilter()
	mlpLegend()
end
